/////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND ListBox_hWnd = NULL;

    static HMENU SystemMenu     = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        MainDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(MainDialog_hWnd, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");
        AppendMenu(SystemMenu, MF_STRING, 1001, "Version");
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1002, "www.NetWorkDLS.com");

        SendMessage(MainDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)DialogCaption);
        SendMessage(MainDialog_hWnd, WM_SETICON, TRUE, (LPARAM)LoadIcon(MainInstance, MAKEINTRESOURCE(100)) );

        ListBox_hWnd = GetDlgItem(MainDialog_hWnd, 1000);

        char TempText[2048];

        sprintf(TempText, "-Data file :");
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tLogical Name : %s", LogicalName1);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tPhysical name : %s", PhysicalName1);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tType : %s", Type1);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tFile group name : %s", FileGroupName1);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tSize : %s", Size1);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tMax size : %s", MaxSize1);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);

        InsertListBoxItem(ListBox_hWnd,"", -1);

        sprintf(TempText, "-Log file :");
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tLogical Name : %s", LogicalName2);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tPhysical name : %s", PhysicalName1);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tType : %s", Type2);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tFile group name : %s", FileGroupName2);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tSize : %s", Size2);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tMax size : %s", MaxSize2);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);

        InsertListBoxItem(ListBox_hWnd,"", -1);

        sprintf(TempText, "-Backup information :");
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tUser name : %s", UserName);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tServer name : %s", ServerName);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tMachine name : %s", MachineName);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tDatabase name : %s", DatabaseName);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tDatabase version : %s", DatabaseVersion);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tDatabase creation date : %s", DatabaseCreationDate);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tBackup size : %s", BackupSize);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tBackup start date : %s", BackupStartDate);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tBackup end date : %s", BackupEndDate);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tCompatibility level : %s", CompatibilityLevel);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tBinding ID : %s", BindingID);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tRecovery fork ID : %s", RecoveryForkID);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);
        sprintf(TempText, "\tCollation : %s", Collation);
        InsertListBoxItem(ListBox_hWnd,TempText, -1);

        CenterWindow(MainDialog_hWnd);

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE ) // Received A Message
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(ListBox_hWnd, 0, 0, nWidth, nHeight, TRUE);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == 100) //- Okay (Dialog Command)
        {
            return 0;
        }

        if(wParam == 200) //- Exit (Dialog Command)
        {
            EndDialog(MainDialog_hWnd,0);
            DestroyWindow(MainDialog_hWnd);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            NetLogo(MainDialog_hWnd);
            return 0;
        }

        if(LOWORD(wParam) == 1001) //- Version (SysMenu Command)
        {
            char VersionText[128];
            sprintf(VersionText, "%s, Version %s", TitleCaption, FileVersion);
            MessageBox(MainDialog_hWnd, VersionText, "Application Version", MB_TASKMODAL);
            return 0;
        }

        if(LOWORD(wParam) == 1002) //- www.NetWorkDLS.com (SysMenu Command)
        {
            ShellExecute(0,"Open", "Http://www.NetWorkDLS.com", NULL, NULL, SW_SHOWNORMAL);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(MainDialog_hWnd,0);
        DestroyWindow(MainDialog_hWnd);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}
//////////////////////////////////////////////////////////////////////

